Public Class Form1
    Inherits System.Windows.Forms.Form

    ' Variables membres de l'interface.
    Private WithEvents btnReadXML As System.Windows.Forms.Button
    Private WithEvents btnGetChildRels As System.Windows.Forms.Button
    Private WithEvents txtCustID As System.Windows.Forms.TextBox
    Private WithEvents btnGetInfo As System.Windows.Forms.Button
    Private WithEvents btnToXML As System.Windows.Forms.Button
    Private WithEvents CustomerDataGrid As System.Windows.Forms.DataGrid
    Private WithEvents CarDataGrid As System.Windows.Forms.DataGrid

    ' DataTable pour l'inventaire.
    Private inventoryTable As DataTable = New DataTable("Inventory")

    ' DataTable pour les clients.
    Private customersTable As DataTable = New DataTable("Customers")

    ' DataTable pour les commandes.
    Private ordersTable As DataTable = New DataTable("Orders")

    ' Notre DataSet.
    Private carsDataSet As DataSet = New DataSet("CarDataSet")

    ' Notre liste de voitures et de clients.
    Private arTheCars, arTheCustomers As ArrayList

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'Cet appel est requis par le concepteur Windows Form.
        InitializeComponent()

        'Ajoutez toute initialisation aprs l'appel  InitializeComponent()
        CenterToScreen()

        ' Remplir l'objet ArrayList avec des voitures.
        arTheCars = New ArrayList()
        arTheCars.Add(New Car("Chucky", "BMW", "Vert"))
        arTheCars.Add(New Car("Tiny", "Yugo", "Blanc"))
        arTheCars.Add(New Car("", "Jeep", "Marron"))
        arTheCars.Add(New Car("Pain Inducer", "Caravan", "Rose"))
        arTheCars.Add(New Car("Fred", "BMW", "Vert"))
        arTheCars.Add(New Car("Buddha", "BMW", "Noir"))
        arTheCars.Add(New Car("Mel", "Firebird", "Rouge"))
        arTheCars.Add(New Car("Sarah", "Colt", "Noir"))

        ' Remplir la liste de tableau avec quelques clients.
        arTheCustomers = New ArrayList()
        arTheCustomers.Add(New Customer("Dave", "Brenner", 1020))
        arTheCustomers.Add(New Customer("Mike", "Larson", 1040))
        arTheCustomers.Add(New Customer("Eric", "Hollnagle", 1010))

        ' Construire les tables de donnes.
        MakeInventoryTable()
        MakeCustomerTable()
        MakeOrderTable()

        ' Ajouter une relation.
        BuildTableRelationship()

        ' Ajouter les contraintes de cl trangre.
        AddConstraints()

        ' Effectuer la liaison  la grille.
        CarDataGrid.SetDataBinding(carsDataSet, "Inventory")
        CustomerDataGrid.SetDataBinding(carsDataSet, "Customers")
        btnReadXML.Enabled = False
    End Sub

    'La classe Form surcharge la mthode dispose pour nettoyer la liste de composants.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Requis par le Concepteur Windows Form
    Private components As System.ComponentModel.Container

    'NOTE: La procdure suivante est requise par le Concepteur Windows Form
    'Elle peut tre modifie en utilisant le Concepteur Windows Form.  
    'Ne pas la modifier en utilisant le Concepteur Windows Form.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.btnToXML = New System.Windows.Forms.Button()
        Me.btnGetChildRels = New System.Windows.Forms.Button()
        Me.CarDataGrid = New System.Windows.Forms.DataGrid()
        Me.txtCustID = New System.Windows.Forms.TextBox()
        Me.btnGetInfo = New System.Windows.Forms.Button()
        Me.CustomerDataGrid = New System.Windows.Forms.DataGrid()
        Me.btnReadXML = New System.Windows.Forms.Button()
        CType(Me.CarDataGrid, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.CustomerDataGrid, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        'btnToXML
        '
        Me.btnToXML.Location = New System.Drawing.Point(16, 320)
        Me.btnToXML.Name = "btnToXML"
        Me.btnToXML.Size = New System.Drawing.Size(88, 72)
        Me.btnToXML.TabIndex = 4
        Me.btnToXML.Text = "Ecrire les donnes en XML"
        '
        'btnGetChildRels
        '
        Me.btnGetChildRels.Location = New System.Drawing.Point(200, 320)
        Me.btnGetChildRels.Name = "btnGetChildRels"
        Me.btnGetChildRels.Size = New System.Drawing.Size(88, 72)
        Me.btnGetChildRels.TabIndex = 7
        Me.btnGetChildRels.Text = "Rcuprer les relations enfants pour la table de commande"
        '
        'CarDataGrid
        '
        Me.CarDataGrid.CaptionFont = New System.Drawing.Font("Microsoft Sans Serif", 11!, System.Drawing.FontStyle.Bold)
        Me.CarDataGrid.CaptionText = "Inventaire"
        Me.CarDataGrid.DataMember = ""
        Me.CarDataGrid.Font = New System.Drawing.Font("Microsoft Sans Serif", 8!)
        Me.CarDataGrid.Location = New System.Drawing.Point(16, 16)
        Me.CarDataGrid.Name = "CarDataGrid"
        Me.CarDataGrid.Size = New System.Drawing.Size(440, 152)
        Me.CarDataGrid.TabIndex = 1
        '
        'txtCustID
        '
        Me.txtCustID.Location = New System.Drawing.Point(392, 328)
        Me.txtCustID.Name = "txtCustID"
        Me.txtCustID.Size = New System.Drawing.Size(64, 20)
        Me.txtCustID.TabIndex = 6
        Me.txtCustID.Text = "1"
        '
        'btnGetInfo
        '
        Me.btnGetInfo.Location = New System.Drawing.Point(296, 320)
        Me.btnGetInfo.Name = "btnGetInfo"
        Me.btnGetInfo.Size = New System.Drawing.Size(88, 72)
        Me.btnGetInfo.TabIndex = 5
        Me.btnGetInfo.Text = "Rcuprer les informations sur le client suivant:"
        '
        'CustomerDataGrid
        '
        Me.CustomerDataGrid.CaptionFont = New System.Drawing.Font("Microsoft Sans Serif", 11!, System.Drawing.FontStyle.Bold)
        Me.CustomerDataGrid.CaptionText = "Clients"
        Me.CustomerDataGrid.DataMember = ""
        Me.CustomerDataGrid.Location = New System.Drawing.Point(16, 184)
        Me.CustomerDataGrid.Name = "CustomerDataGrid"
        Me.CustomerDataGrid.Size = New System.Drawing.Size(440, 120)
        Me.CustomerDataGrid.TabIndex = 2
        '
        'btnReadXML
        '
        Me.btnReadXML.Location = New System.Drawing.Point(112, 320)
        Me.btnReadXML.Name = "btnReadXML"
        Me.btnReadXML.Size = New System.Drawing.Size(80, 72)
        Me.btnReadXML.TabIndex = 8
        Me.btnReadXML.Text = "Reconstruire les donnes depuis XML"
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(468, 401)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.btnReadXML, Me.btnGetChildRels, Me.txtCustID, Me.btnGetInfo, Me.btnToXML, Me.CustomerDataGrid, Me.CarDataGrid})
        Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle
        Me.Name = "Form1"
        Me.Text = "Car Data Table"
        CType(Me.CarDataGrid, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.CustomerDataGrid, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub btnToXML_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnToXML.Click
        carsDataSet.WriteXml("cars.xml")
        MessageBox.Show("CarDataSet transform en fichier XML dans le rpertoire de l'application")
        btnReadXML.Enabled = True
    End Sub

    Private Sub btnReadXML_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnReadXML.Click
        ' Dtruire le DataSet courant.
        carsDataSet.Clear()
        carsDataSet.Dispose()
        MessageBox.Show("La table de donne vient d'tre rinitialise...")
        carsDataSet = New DataSet("CarDataSet")

        ' En construire un  l'aide de XML.
        carsDataSet.ReadXml("cars.xml")
        MessageBox.Show("Rcupration de l'ensemble des donnes depuis le fichier XML...")
        btnReadXML.Enabled = False

        ' Effectuer la liaison  la grille.
        CarDataGrid.SetDataBinding(carsDataSet, "Inventory")
        CustomerDataGrid.SetDataBinding(carsDataSet, "Customers")
    End Sub

    Private Sub btnGetChildRels_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetChildRels.Click
        ' Demander les relations enfants de la table inventaire  l'objet CarsDataSet.
        Dim relCol As DataRelationCollection
        Dim arrRows() As DataRow
        Dim info As String
        relCol = carsDataSet.Tables("inventory").ChildRelations

        info &= "La relation s'appelle: " & relCol(0).RelationName + vbLf
        ' Maintenant parcourir l'ensemble des relations et afficher les informations.
        Dim dr As DataRelation
        For Each dr In relCol
            Dim r As DataRow
            For Each r In inventoryTable.Rows
                arrRows = r.GetChildRows(dr)
                ' Afficher les valeurs de chaque colonne dans la ligne.
                Dim i As Integer
                For i = 0 To arrRows.Length - 1
                    Dim dc As DataColumn
                    For Each dc In arrRows(i).Table.Columns

                        info &= "      " & arrRows(i)(dc).ToString()
                    Next
                    info += vbLf
                Next
            Next
            MessageBox.Show(info, _
                      "Donnes dans la table de commandes obtenue par des relations enfants")
        Next
    End Sub

    Private Sub btnGetInfo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetInfo.Click
        Dim strInfo As String

        Dim drsOrder() As DataRow

        ' Rcuprer la valeur spcifie de CustID depuis le contrle TextBox.
        Dim theCust As Integer = Integer.Parse(Me.txtCustID.Text)

        ' Maintenant, en fonction de CustID, rcuprer la bonne ligne dans la table de clients.
        Dim drCust As DataRow
        drCust = carsDataSet.Tables("Customers").Rows(theCust)
        strInfo &= "client #" & drCust("CustID").ToString() & vbLf

        ' Se dplacer de la table de clients vers la table de commandes.
        drsOrder = drCust.GetChildRows(carsDataSet.Relations("CustomerOrder"))

        ' Rcuprer le nom du client.
        Dim r As DataRow
        For Each r In drsOrder
            strInfo &= "Numro de commande: " & r("OrderID").ToString() & vbLf
        Next

        ' Maintenant se dplacer de la table de commandes vers la table d'inventaire.
        Dim drsInv() As DataRow = _
        drsOrder(0).GetParentRows(carsDataSet.Relations("InventoryOrder"))

        ' Rcuprer des informations sur la voiture.
        For Each r In drsInv
            strInfo &= "Constructeur: " & r("Make").ToString() & vbLf
            strInfo &= "Couleur: " & r("Color").ToString() & vbLf
            strInfo &= "Surnom: " & r("PetName").ToString() & vbLf
        Next
        MessageBox.Show(strInfo, "Informartions bases sur l'ID du client")
    End Sub

    Private Sub MakeInventoryTable()
        ' Ajouter  l'objet DataSet...
        carsDataSet.Tables.Add(inventoryTable)

        ' Variable DataColumn.
        Dim myDataColumn As DataColumn

        ' Crer la colonne CarID et l'ajouter  la table.
        myDataColumn = New DataColumn()
        myDataColumn.DataType = Type.GetType("System.Int32")
        myDataColumn.ColumnName = "CarID"
        myDataColumn.ReadOnly = True
        myDataColumn.AllowDBNull = False
        myDataColumn.Unique = True

        ' Configurer l'auto-incrmentation.
        myDataColumn.AutoIncrement = True
        myDataColumn.AutoIncrementSeed = 1000
        myDataColumn.AutoIncrementStep = 10
        carsDataSet.Tables("Inventory").Columns.Add(myDataColumn)

        ' Crer la colonne Make et l'ajouter  la table.    
        myDataColumn = New DataColumn()
        myDataColumn.DataType = Type.GetType("System.String")
        myDataColumn.ColumnName = "Make"
        carsDataSet.Tables("Inventory").Columns.Add(myDataColumn)

        ' Crer la colonne Color et l'ajouter  la table.
        myDataColumn = New DataColumn()
        myDataColumn.DataType = Type.GetType("System.String")
        myDataColumn.ColumnName = "Color"
        carsDataSet.Tables("Inventory").Columns.Add(myDataColumn)

        ' Crer la colonne PetName et l'ajouter  la table.
        myDataColumn = New DataColumn()
        myDataColumn.DataType = Type.GetType("System.String")
        myDataColumn.ColumnName = "PetName"
        myDataColumn.AllowDBNull = True
        carsDataSet.Tables("Inventory").Columns.Add(myDataColumn)

        ' Dfinir la colonne ID comme colonne des cl primaire.
        Dim PK(0) As DataColumn
        PK(0) = inventoryTable.Columns("CarID")
        carsDataSet.Tables("Inventory").PrimaryKey = PK

        ' Parcourir l'objet ArrayList pour construire les lignes.
        Dim c As Car
        For Each c In arTheCars
            Dim newRow As DataRow
            newRow = inventoryTable.NewRow()
            newRow("Make") = c.mMake
            newRow("Color") = c.mColor
            newRow("PetName") = c.mPetName
            carsDataSet.Tables("Inventory").Rows.Add(newRow)
        Next
    End Sub

    Private Sub MakeOrderTable()
        ' Ajouter l'objet DataSet...
        carsDataSet.Tables.Add(ordersTable)

        ' Variables de DataColumn.
        Dim myDataColumn As DataColumn

        ' Crer la colonne OrderID et l'ajouter  la table.
        myDataColumn = New DataColumn()
        myDataColumn.DataType = Type.GetType("System.Int32")
        myDataColumn.ColumnName = "OrderID"
        myDataColumn.ReadOnly = True
        myDataColumn.AllowDBNull = False
        myDataColumn.Unique = True
        myDataColumn.AutoIncrement = True
        myDataColumn.AutoIncrementSeed = 0
        myDataColumn.AutoIncrementStep = 1

        carsDataSet.Tables("Orders").Columns.Add(myDataColumn)

        ' Crer la colonne CustID et l'ajouter  la table.
        myDataColumn = New DataColumn()
        myDataColumn.DataType = Type.GetType("System.Int32")
        myDataColumn.ColumnName = "CustID"
        carsDataSet.Tables("Orders").Columns.Add(myDataColumn)

        ' Crer la colonne CarID et l'ajouter  la table.
        myDataColumn = New DataColumn()
        myDataColumn.DataType = Type.GetType("System.Int32")
        myDataColumn.ColumnName = "CarID"
        carsDataSet.Tables("Orders").Columns.Add(myDataColumn)

        ' Dfinir la colonne ID comme colonne de cl primaire.
        Dim PK(0) As DataColumn
        PK(0) = customersTable.Columns("OrderID")
        carsDataSet.Tables("Orders").PrimaryKey = PK

        ' Ajouter quelques commandes.
        Dim i As Integer
        For i = 0 To arTheCustomers.Count - 1

            Dim newRow As DataRow
            newRow = ordersTable.NewRow()

            Dim c As Customer = CType(arTheCustomers(i), Customer)
            newRow("CustID") = i
            newRow("CarID") = c.currCarOrder
            carsDataSet.Tables("Orders").Rows.Add(newRow)
        Next
    End Sub

    Private Sub MakeCustomerTable()
        ' Ajouter l'objet DataSet...
        carsDataSet.Tables.Add(customersTable)

        ' Variable DataColumn.
        Dim myDataColumn As DataColumn

        ' Crer la colonne CustID et l'ajouter  la table.
        myDataColumn = New DataColumn()
        myDataColumn.DataType = Type.GetType("System.Int32")
        myDataColumn.ColumnName = "CustID"
        myDataColumn.ReadOnly = True
        myDataColumn.AllowDBNull = False
        myDataColumn.Unique = True
        myDataColumn.AutoIncrement = True
        myDataColumn.AutoIncrementSeed = 0
        myDataColumn.AutoIncrementStep = 1

        carsDataSet.Tables("Customers").Columns.Add(myDataColumn)

        ' Crer la colonne FirstName et l'ajouter  la table.
        myDataColumn = New DataColumn()
        myDataColumn.DataType = Type.GetType("System.String")
        myDataColumn.ColumnName = "FirstName"
        carsDataSet.Tables("Customers").Columns.Add(myDataColumn)

        ' Crer la colonne LastName et l'ajouter  la table.
        myDataColumn = New DataColumn()
        myDataColumn.DataType = Type.GetType("System.String")
        myDataColumn.ColumnName = "LastName"
        carsDataSet.Tables("Customers").Columns.Add(myDataColumn)

        ' Dfinir la colonne ID comme colonne de cl primaire.
        Dim PK(0) As DataColumn
        PK(0) = customersTable.Columns("CustID")
        carsDataSet.Tables("Customers").PrimaryKey = PK

        ' Parcourir l'objet ArrayList pour remplir les lignes.
        Dim c As Customer
        For Each c In arTheCustomers
            Dim newRow As DataRow
            newRow = customersTable.NewRow()
            newRow("FirstName") = c.firstName
            newRow("LastName") = c.lastName
            carsDataSet.Tables("Customers").Rows.Add(newRow)
        Next
    End Sub

    Private Sub BuildTableRelationship()

        ' Crer un objet DataRelation.
        Dim dr As DataRelation _
            = New DataRelation("CustomerOrder", _
            carsDataSet.Tables("Customers").Columns("CustID"), _
            carsDataSet.Tables("Orders").Columns("CustID"))

        ' L'ajouter au DataSet.
        Try
            carsDataSet.Relations.Add(dr)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try

        ' Crer un autre objet DataRelation.
        dr = New DataRelation("InventoryOrder", _
          carsDataSet.Tables("Inventory").Columns("CarID"), _
          carsDataSet.Tables("Orders").Columns("CarID"))

        ' L'ajouter au DataSet.
        Try
            carsDataSet.Relations.Add(dr)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub

    Private Sub AddConstraints()
        carsDataSet.EnforceConstraints = True
    End Sub
End Class
